/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.passwordprotect.listeners;

import de.dustplanet.passwordprotect.PasswordProtect;
import de.dustplanet.passwordprotect.jail.JailHelper;
import de.dustplanet.passwordprotect.utils.PasswordProtectUtilities;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.BanList;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@SuppressFBWarnings(value={"IMC_IMMATURE_CLASS_NO_TOSTRING"})
public class PasswordProtectPlayerListener
implements Listener {
    private static final int POTION_AMPLIFIER = 15;
    private static final int TICKS_PER_SECOND = 20;
    private final PasswordProtect plugin;
    private final PasswordProtectUtilities utils;
    private final JailHelper jailHelper;

    public PasswordProtectPlayerListener(PasswordProtect instance, JailHelper jailHelper) {
        this.plugin = instance;
        this.utils = instance.getUtils();
        this.jailHelper = jailHelper;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.jailHelper.check(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerUUID = event.getPlayer().getUniqueId();
        Player player = event.getPlayer();
        if (this.jailHelper.getJailedPlayers().containsKey(playerUUID)) {
            if (player.hasPotionEffect(PotionEffectType.BLINDNESS)) {
                player.removePotionEffect(PotionEffectType.BLINDNESS);
            }
            if (player.hasPotionEffect(PotionEffectType.SLOW)) {
                player.removePotionEffect(PotionEffectType.SLOW);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.plugin.getConfig().getBoolean("prevent.movement", true)) {
            return;
        }
        UUID playerUUID = event.getPlayer().getUniqueId();
        Player player = event.getPlayer();
        if (this.jailHelper.getJailedPlayers().containsKey(playerUUID)) {
            if (!player.hasPotionEffect(PotionEffectType.BLINDNESS) && this.plugin.getConfig().getBoolean("darkness", true)) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, (int)(20L * TimeUnit.DAYS.toSeconds(1L)), 15));
            }
            if (!player.hasPotionEffect(PotionEffectType.SLOW) && this.plugin.getConfig().getBoolean("slowness", true)) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, (int)(20L * TimeUnit.DAYS.toSeconds(1L)), 15));
            }
            this.jailHelper.stayInJail(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.checkBasicEvent((PlayerEvent)event, "prevent.interaction");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        this.checkBasicEvent((PlayerEvent)event, "prevent.interactionMobs");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        this.checkBasicEvent((PlayerEvent)event, "prevent.itemDrop");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerPickupItem(EntityPickupItemEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("prevent.itemPickup", true)) {
            UUID playerUUID = event.getEntity().getUniqueId();
            if (this.jailHelper.getJailedPlayers().containsKey(playerUUID)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerPortal(PlayerPortalEvent event) {
        this.checkBasicEvent((PlayerEvent)event, "prevent.portal");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        this.checkBasicEvent((PlayerEvent)event, "prevent.chat");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    @SuppressFBWarnings(value={"UC_USELESS_CONDITION"})
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) throws Exception {
        Player player = event.getPlayer();
        UUID playerUUID = event.getPlayer().getUniqueId();
        String message = event.getMessage();
        String command = message.replaceFirst("/", "");
        if (command.contains(" ")) {
            command = command.substring(0, command.indexOf(32));
        }
        if (this.jailHelper.getJailedPlayers().containsKey(playerUUID)) {
            if (this.utils.getCommandList().contains(command)) {
                return;
            }
            int loginTextWithSlashLength = 7;
            if (!"login".equalsIgnoreCase(command) || message.length() < 7) {
                this.utils.sendPasswordRequiredMessage(player);
                event.setCancelled(true);
                return;
            }
            String password = message.substring(7, message.length());
            if ((password = this.utils.hash(password)).equals(this.utils.getPassword())) {
                this.loginPlayer(player, playerUUID);
                event.setCancelled(true);
                return;
            }
            int attempts = this.jailHelper.getJailedPlayers().get(playerUUID);
            int kickAfter = this.plugin.getConfig().getInt("wrongAttempts.kick");
            int banAfter = this.plugin.getConfig().getInt("wrongAttempts.ban");
            int attemptsLeftKick = kickAfter - attempts;
            int attemptsLeftBan = banAfter - attempts;
            if (attemptsLeftKick <= 0 || attemptsLeftBan <= 0) {
                if (attemptsLeftBan <= 0) {
                    this.banPlayer(player, playerUUID);
                    return;
                }
                if (attemptsLeftKick == 0) {
                    this.kickPlayer(player);
                }
            }
            if (attemptsLeftKick > 0 || attemptsLeftBan > 0) {
                String messageLocalization;
                if (attemptsLeftKick > 0) {
                    messageLocalization = this.plugin.getLocalization().getString("attempts_left_kick");
                    this.utils.message((CommandSender)player, messageLocalization, Integer.toString(attemptsLeftKick));
                }
                messageLocalization = this.plugin.getLocalization().getString("attempts_left_ban");
                this.utils.message((CommandSender)player, messageLocalization, Integer.toString(attemptsLeftBan));
                this.jailHelper.getJailedPlayers().put(playerUUID, ++attempts);
            }
            event.setCancelled(true);
        } else if (message.toLowerCase(Locale.ENGLISH).startsWith("/login")) {
            String messageLocalization = this.plugin.getLocalization().getString("already_logged_in");
            this.utils.message((CommandSender)player, messageLocalization, null);
            event.setCancelled(true);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void banPlayer(Player player, UUID playerUUID) {
        String ipAddress = player.getAddress().getAddress().toString().replace("/", "");
        String messageLocalization = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLocalization().getString("ban_message"));
        player.kickPlayer(messageLocalization);
        this.plugin.getServer().getBanList(BanList.Type.NAME).addBan(player.getName(), "AutoBan - PasswordProtect", null, "PasswordProtect");
        if (this.plugin.getConfig().getBoolean("broadcast.ban", true)) {
            messageLocalization = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLocalization().getString("ban_broadcast"));
            this.plugin.getServer().broadcastMessage(messageLocalization.replace("%player", player.getName()));
        }
        if (this.plugin.getConfig().getBoolean("wrongAttempts.banIP", true)) {
            this.plugin.getServer().banIP(ipAddress);
        }
        this.jailHelper.getJailedPlayers().remove(playerUUID);
        if (this.jailHelper.getPlayerLocations().containsKey(playerUUID)) {
            this.jailHelper.getPlayerLocations().remove(playerUUID);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void kickPlayer(Player player) {
        String messageLocalization = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLocalization().getString("kick_message"));
        player.kickPlayer(messageLocalization);
        if (player.hasPotionEffect(PotionEffectType.BLINDNESS)) {
            player.removePotionEffect(PotionEffectType.BLINDNESS);
        }
        if (player.hasPotionEffect(PotionEffectType.SLOW)) {
            player.removePotionEffect(PotionEffectType.SLOW);
        }
        if (this.plugin.getConfig().getBoolean("broadcast.kick", true)) {
            messageLocalization = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLocalization().getString("kick_broadcast"));
            this.plugin.getServer().broadcastMessage(messageLocalization.replace("%player", player.getName()));
        }
    }

    private void loginPlayer(Player player, UUID playerUUID) {
        String messageLocalization = this.plugin.getLocalization().getString("password_accepted");
        this.utils.message((CommandSender)player, messageLocalization, null);
        this.jailHelper.getJailedPlayers().remove(playerUUID);
        if (player.hasPotionEffect(PotionEffectType.BLINDNESS)) {
            player.removePotionEffect(PotionEffectType.BLINDNESS);
        }
        if (player.hasPotionEffect(PotionEffectType.SLOW)) {
            player.removePotionEffect(PotionEffectType.SLOW);
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            player.setAllowFlight(true);
        }
        if (this.plugin.getConfig().getBoolean("teleportBack", true) && this.jailHelper.getPlayerLocations().containsKey(playerUUID)) {
            Location location = this.jailHelper.getPlayerLocations().remove(playerUUID);
            player.teleport(location);
        }
    }

    private void checkBasicEvent(PlayerEvent event, String configKey) {
        if (this.plugin.getConfig().getBoolean(configKey, true)) {
            UUID playerUUID = event.getPlayer().getUniqueId();
            if (this.jailHelper.getJailedPlayers().containsKey(playerUUID)) {
                ((Cancellable)event).setCancelled(true);
            }
        }
    }
}

